<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

// Check if user is logged in
requireLogin();

try {
    $pdo->beginTransaction();

    // 1. Add a sample supplier if not exists
    $stmt = $pdo->prepare("INSERT INTO suppliers (name, contact_person, phone, email, address) 
                          SELECT ?, ?, ?, ?, ? 
                          WHERE NOT EXISTS (SELECT 1 FROM suppliers WHERE name = ?)");
    $stmt->execute([
        'Sample Supplier Ltd',
        'John Doe',
        '+254712345678',
        'john@supplier.com',
        '123 Supplier Street, Nairobi',
        'Sample Supplier Ltd'
    ]);
    $supplier_id = $pdo->lastInsertId() ?: $pdo->query("SELECT id FROM suppliers WHERE name = 'Sample Supplier Ltd'")->fetchColumn();

    // 2. Get some existing products
    $products = $pdo->query("SELECT id, name FROM products LIMIT 3")->fetchAll();
    
    if (empty($products)) {
        // If no products exist, create some sample products
        $stmt = $pdo->prepare("INSERT INTO products (name, serial_no, description, category_id, price, cost_price, quantity, alert_quantity) 
                              VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        
        // Get or create a default category
        $category_id = $pdo->query("SELECT id FROM categories LIMIT 1")->fetchColumn();
        if (!$category_id) {
            $pdo->exec("INSERT INTO categories (name) VALUES ('General')");
            $category_id = $pdo->lastInsertId();
        }

        // Add sample products
        $sample_products = [
            ['Product A', 'PA001', 'Sample Product A', $category_id, 1000, 800, 0, 10],
            ['Product B', 'PB001', 'Sample Product B', $category_id, 1500, 1200, 0, 15],
            ['Product C', 'PC001', 'Sample Product C', $category_id, 2000, 1600, 0, 20]
        ];

        foreach ($sample_products as $product) {
            $stmt->execute($product);
        }

        // Get the newly created products
        $products = $pdo->query("SELECT id, name FROM products ORDER BY id DESC LIMIT 3")->fetchAll();
    }

    // 3. Add supplier receipts for each product
    $stmt = $pdo->prepare("INSERT INTO supplier_receipts 
                          (supplier_id, product_id, quantity, unit_price, status, payment_status, created_at, created_by) 
                          VALUES (?, ?, ?, ?, ?, ?, NOW(), ?)");

    foreach ($products as $product) {
        $stmt->execute([
            $supplier_id,
            $product['id'],
            rand(10, 50), // Random quantity between 10 and 50
            rand(500, 2000), // Random unit price between 500 and 2000
            'approved',
            'pending',
            $_SESSION['user_id'] // Add the current user's ID
        ]);
    }

    $pdo->commit();
    echo "Sample supplier data has been set up successfully!<br>";
    echo "Supplier ID: " . $supplier_id . "<br>";
    echo "Added receipts for " . count($products) . " products.<br>";
    echo "<a href='products.php'>Go to Products Page</a>";

} catch (Exception $e) {
    $pdo->rollBack();
    echo "Error setting up supplier data: " . $e->getMessage();
} 